#ifndef __GRAPHIC_LIB
#define __GRAPHIC_LIB

//#include <crtdbg.h>
//#include <stdio.h>
#include <afx.h>

struct ScreenInfo{
	DWORD width;
	DWORD height;
	DWORD colorDepth;
};
// screenInfo defined in bitmap.cpp
extern ScreenInfo screenInfo;	//set by ddraw.cpp
//ڴȡɫ
extern DWORD colorMask[6];
//alpha,betaMMX,rbMaskȡ,gMaskȡ(cloudwu㷨)
extern DWORD rbMask, gMask;

struct PixelInfo{
	int colorRedMask;
	int colorRedPos;
	int redMask;
	int redPos;

	int colorGreenMask;
	int colorGreenPos;
	int greenMask;
	int greenPos;

	int colorBlueMask;
	int colorBluePos;
	int blueMask;
	int bluePos;
};
extern PixelInfo pixelInfo16, pixelInfo15, pixelInfo24, pixelInfo32;

// 
int InitGraphicLibrary( int colorDepth );

/////////////////////////////////////////////////////////////////////
// ɫ

#define PAL_SIZE	256

typedef int RGB;

struct ColorEntry{
	union{
		struct{
		BYTE rgbBlue;
		BYTE rgbGreen;
		BYTE rgbRed;
		BYTE rgbRsvd ;
		};
		DWORD rgb;
	};
};

struct Palette{
	int count;
	ColorEntry palette[ PAL_SIZE ];
	int screenPal[ PAL_SIZE ];	// convert to current pixel mode
	
	Palette();
	void AddRef( void );
	void Release( void );
	void Convert( void );
	void Destroy( void );
	void WriteToDisk( FILE *fp, int num = PAL_SIZE );
	void ReadFromDisk( FILE *fp, int num = PAL_SIZE );
};


/////////////////////////////////////////////////////////////////////
// ڴλͼ

#define BYTES_PER_PIXEL( a ) (( a + 7 ) >> 3 )
#define COLOR_INDEX( c ) ( c & 0x80000000 )

#define COLORKEY8   0
#define COLORKEY15	0x7c1f
#define COLORKEY16  0xf81f
#define COLORKEY24  0xff00ff
#define COLORKEY32  0xff00ff

class Bitmap;
class Bitmap15;
class Bitmap16;

Bitmap* CreateBitmap( int w, int h );
Bitmap* CreateBitmapEx( int w, int h, int colorDepth );
Bitmap* LoadBmp( char *filename, Palette *pal );
Bitmap* LoadTga( char *filename, Palette *pal );
Bitmap* LoadPicture( char* filename, int convert = 1, Palette* pal = NULL );
int SaveTga( char *filename, Bitmap *bmp );

class Bitmap{
public:
	static int drawMode;	// solid, xor, blend ( not support pattern )
	static int alpha;
	
	enum{
		SolidMode = 0x1,
		XorMode = 0x2,
		AlphaMode = 0x4,
		BetaMode = 0x8
		};
			
	int width, height;
	int colorDepth;
	int clip;	// true or false
	int cl, ct, cr, cb;	//clip rectangle
	void* dat;	//data area
/*	int id;		//ID
	int dx, dy;	// for sub bitmap
*/	char** line;	// line addresses
	int color; 	// current color	
	int colorKey;	// SOURCE and TARGET color key
	int pitch;	// the scanline length in dat ( the same as directdraw )
					//( may be larger than actual length for alignment purpose )
	
	// functions
	Bitmap();

	int  GetClip(){
		return clip;
	};
	
	void SetClip( int l, int t, int r, int b );
	void SetClip( int enable );
	void SetDrawMode( int drawmode, int alpha );

	virtual Bitmap* ConvertFormat( int ) = 0;
	virtual int  MakeColor( RGB color ) = 0;
	virtual void SetColor( RGB color ) = 0;
	virtual void SetColorKey( RGB color ) = 0;

	// color = 0x00rrggbb ( 15,16,24,32 ) / 0x800000cc ( 8bit color )
	virtual DWORD GetPixel( int x, int y ) = 0;
	virtual void PutPixel( int x, int y ) = 0; 
	virtual void Blit( Bitmap* dest, int dx, int dy, int sx, int sy, int w, int h ) = 0;
	virtual void BlitMask( Bitmap* dest, int dx, int dy, int sx, int sy, int w, int h ) = 0;
	virtual void Clear( int l, int t, int w, int h, int color = COLORKEY16 ) = 0;

};

// supports 8 bits color mode 
class Bitmap8 : public Bitmap{ 
public:
	Palette *palette;

	~Bitmap8();
	
	virtual void Blit( Bitmap* dest, int dx, int dy, int sx, int sy, int w, int h );
	virtual void BlitInside8( int x, int y, int sx, int sy, int w, int h );
	virtual void BlitOutside8( Bitmap8* dest, int x, int y, int sx, int sy, int w, int h );
	virtual void BlitMask( Bitmap* dest, int x, int y, int sx, int sy, int w, int h );
	virtual void BlitMasked8( Bitmap8* dest, int x, int y, int sx, int sy, int w, int h );
	virtual void BlitMaskedTo16( Bitmap16* dest, int x, int y, int sx, int sy, int w, int h );
	virtual void Clear( int l, int t, int w, int h, int color = COLORKEY8 );
	virtual Bitmap* ConvertFormat( int );
	virtual DWORD GetPixel( int x, int y );
	virtual void PutPixel( int x, int y ); 
	
	inline virtual int MakeColor( RGB color ){ 
		return 0; 
	};
	inline virtual int  GetR( int pixel ){
		return 0;
	};
	inline virtual int  GetG( int pixel ){
		return 0;
	};
	inline virtual int  GetB( int pixel ){
		return 0;
	};
	virtual void SetColor( RGB color );
	virtual void SetColorKey( RGB color );
};

// 15/16λɫλͼĻ
class BitmapHi : public Bitmap{
public:

	virtual void Blit( Bitmap* dest, int dx, int dy, int sx, int sy, int w, int h );
	virtual void BlitMask( Bitmap* dest, int x, int y, int sx, int sy, int w, int h );
	virtual void Clear( int l, int t, int w, int h, int color = COLORKEY16 );
	// 
	virtual void BlitMasked( Bitmap* dest, int x, int y, int sx, int sy, int w, int h );
	virtual void BlitInside( int x, int y, int sx, int sy, int w, int h );
	virtual void BlitOutside( Bitmap* dest, int x, int y, int sx, int sy, int w, int h );

	BitmapHi();
	~BitmapHi();

	virtual Bitmap* ConvertFormat( int ) = 0;
	virtual DWORD GetPixel( int x, int y );
	virtual void PutPixel( int x, int y ); 
	virtual int  MakeColor( RGB color ) = 0;

	// set current draw color
	inline virtual void SetColor( RGB color )
	{
		Bitmap::color = MakeColor( color );
	};
	// set color key
	inline virtual void SetColorKey( RGB color ){
		colorKey = MakeColor( color );
	};

};

// 565ģʽλͼ
class Bitmap16 : public BitmapHi{
public:

	virtual Bitmap* ConvertFormat( int );

	inline virtual int  MakeColor( RGB color )
	{
		return (((color & 0xf80000)>>8 ) | (color & 0xfc00)>>5 | (color&0xf8)>>3);
	};

};

// 555ģʽλͼ
class Bitmap15 : public BitmapHi{
public:

	virtual Bitmap* ConvertFormat( int );

	inline virtual int  MakeColor( RGB color )
	{
		return (((color & 0xf80000)>>9 ) | (color & 0xf800)>>5 | (color&0xf8)>>3);
	};

};

// supports 24 bits color mode
class Bitmap24 : public Bitmap{
public:

	virtual void Blit( Bitmap* dest, int dx, int dy, int sx, int sy, int w, int h );
	void BlitInside24( int x, int y, int sx, int sy, int w, int h );
	void BlitOutside24( Bitmap24* dest, int x, int y, int sx, int sy, int w, int h );
	virtual void BlitMask( Bitmap* dest, int x, int y, int sx, int sy, int w, int h );
	void BlitMasked24( Bitmap24* dest, int x, int y, int sx, int sy, int w, int h );
	virtual void Clear( int l, int t, int w, int h, int color );
	virtual Bitmap* ConvertFormat( int );
	virtual DWORD GetPixel( int x, int y );
	virtual void PutPixel( int x, int y ); 
	virtual void SetColor( int color );
	virtual void SetColorKey( int color );
	
	inline virtual int MakeColor( RGB color ){
		return ( color & 0xffffff );
	};

	inline virtual int  GetR( int pixel ){
		return (( pixel >> 16 ) & 0xff );
	};

	inline virtual int  GetG( int pixel ){
		return (( pixel >> 8 ) & 0xff );
	};

	inline virtual int  GetB( int pixel ){
		return ( pixel & 0xff );
	};

};

// supports 32 bits color mode
class Bitmap32 : public Bitmap{
public:

	virtual void Blit( Bitmap* dest, int dx, int dy, int sx, int sy, int w, int h );
	void BlitInside32( int x, int y, int sx, int sy, int w, int h );
	void BlitOutside32( Bitmap32* dest, int x, int y, int sx, int sy, int w, int h );
	virtual void BlitMask( Bitmap* dest, int x, int y, int sx, int sy, int w, int h );
	void BlitMasked32( Bitmap32* dest, int x, int y, int sx, int sy, int w, int h );
	virtual Bitmap* ConvertFormat( int );
	virtual void Clear( int l, int t, int w, int h, int color );
	virtual DWORD GetPixel( int x, int y );
	virtual void PutPixel( int x, int y ); 
	
	inline virtual int  MakeColor( RGB color ){
		return color & 0xffffff;
	};		

	inline virtual int  GetR( int pixel ){
		return (( pixel >> 16 ) & 0xff );
	};

	inline virtual int  GetG( int pixel ){
		return (( pixel >> 8 ) & 0xff );
	};

	inline virtual int  GetB( int pixel ){
		return ( pixel & 0xff );
	};
	virtual void SetColor( int color );
	virtual void SetColorKey( int color );
};

/////////////////////////////////////////////////////////////////////
// 򵥾ʾ
typedef void (*SpriteBlitAlphaFunc)( Bitmap*, int, int, Bitmap* );
typedef void (*SpriteBlitBetaFunc)( Bitmap*, int, int, Bitmap* );

extern SpriteBlitAlphaFunc SpriteBlitAlpha;
extern SpriteBlitBetaFunc SpriteBlitBeta;

int InitSprite( void );
void SpriteSetDrawMode( int mode, DWORD degree );

/*class Sprite;


class Sprite : public BitmapHi{
public:
	static SpriteBlitAlphaFunc BlitAlpha;
	static SpriteBlitBetaFunc BlitBeta;

	void SetDrawMode( int mode, int degree );
};
*/
extern SpriteBlitAlphaFunc spriteBlitAlpha[9];
extern SpriteBlitBetaFunc spriteBlitBeta[9];

// Alphaϵľ鿽
void SpriteBlitAlpha0MMX( Bitmap* dest, int x, int y, Bitmap* src );
void SpriteBlitAlpha1MMX( Bitmap* dest, int x, int y, Bitmap* src );
void SpriteBlitAlpha2MMX( Bitmap* dest, int x, int y, Bitmap* src );
void SpriteBlitAlpha3MMX( Bitmap* dest, int x, int y, Bitmap* src );
void SpriteBlitAlpha4MMX( Bitmap* dest, int x, int y, Bitmap* src );
void SpriteBlitAlpha5MMX( Bitmap* dest, int x, int y, Bitmap* src );
void SpriteBlitAlpha6MMX( Bitmap* dest, int x, int y, Bitmap* src );
void SpriteBlitAlpha7MMX( Bitmap* dest, int x, int y, Bitmap* src );
void SpriteBlitAlpha8MMX( Bitmap* dest, int x, int y, Bitmap* src );

// ľ鿽
void SpriteBlitBeta0MMX( Bitmap* dest, int x, int y, Bitmap* src );
void SpriteBlitBeta1MMX( Bitmap* dest, int x, int y, Bitmap* src );
void SpriteBlitBeta2MMX( Bitmap* dest, int x, int y, Bitmap* src );
void SpriteBlitBeta3MMX( Bitmap* dest, int x, int y, Bitmap* src );
void SpriteBlitBeta4MMX( Bitmap* dest, int x, int y, Bitmap* src );
void SpriteBlitBeta5MMX( Bitmap* dest, int x, int y, Bitmap* src );
void SpriteBlitBeta6MMX( Bitmap* dest, int x, int y, Bitmap* src );
void SpriteBlitBeta7MMX( Bitmap* dest, int x, int y, Bitmap* src );
void SpriteBlitBeta8MMX( Bitmap* dest, int x, int y, Bitmap* src );
void SpriteBlitBeta9MMX( Bitmap* dest, int x, int y, Bitmap* src, int brightness );
void SpriteBlitBeta10MMX( Bitmap* dest, int x, int y, Bitmap* src, int b1, int b2, short* buf );

int testSprite( void );

/////////////////////////////////////////////////////////////////////
// ıʾ,ʹǰȵInitHanzi(int)


class Hanzi{
public:
	static short *hzk12, *hzk16;
	static char* asc12, *asc16;
	
	static char hzk12name[9], hzk16name[9], asc12name[9], asc16name[9];
	static int count;

	static int capabilities;
	enum{
		SmallFont = 0x1,
		MiddleFont = 0x2,
		AllFont = 0x3
	};
	
	static int size;	// 12 or 16 
	enum{
		Small = 12,
		Middle = 16
	};
	
	static short* hzAddr; // current hzk dots data area
	static char* ascAddr; // current ascii dots data area
	
public:
	Hanzi();
	~Hanzi();
	
	static int SetFontSize( int fsize );
	
	void TextOut( Bitmap* bmp, int x, int y, char* str, 
						int color );
	void PutHanzi( Bitmap* bmp, int x, int y, char hz[2] );
	void PutAscii( Bitmap* bmp, int x, int y, char *asc );
	void Printf( Bitmap* bmp, int x, int y, int color, char *format, ... );
};
extern Hanzi hz;
extern int hanziInstalled;

// initialize hanzi display class
int InitHanzi( int fonts );

/////////////////////////////////////////////////////////////////////
// see what type the CPU is 

typedef struct CPUInfo {
	char vendor[16];
	int family;
	int model;
	int fpu; 
	int mmx; 
	int _3dnow;
	int cpuid; 
} CPUInfo;
extern CPUInfo cpu;

void CheckCPU( void );


/////////////////////////////////////////////////////////////////////
// package file 

#define MAX_PATH_LEN 	80
#define MAX_CFILE_NUM	15

#define CFILE_APPEND	0
#define CFILE_DELETE	1

struct File{
	DWORD address;
	DWORD length;
	DWORD count;
	FILE *fp;
	
	File();
	~File();
	
	int Close( void );
	
	inline int Getc( void )
	{
		if( length - count - 1 < 0 )
			return EOF;
		count ++;
		return fgetc( fp );
	};

	char *Gets( char* buf, int size );
	int Getw( void );
	int Getdw( void );
	int Read( void* buffer, DWORD size );
	int Seek( DWORD d, int mode );
};

typedef struct DirItem{
	BYTE type;
	char filename[13];
	DWORD address;
	DWORD length;
} DirItem;

typedef struct Directory{
	long cur;
	long num;
	DirItem *items;

	Directory(){
		items = NULL;
	};	
	~Directory();	
	int ReadDisk( FILE *fp );
	int SearchDir( char dname[13], int type );
	
} Directory;

struct PackageFile{
	char fname[MAX_PATH_LEN];
	Directory *root;
	Directory *currentDir;
	char currentPath[MAX_PATH_LEN];
//	FILE *fp;
};

struct PackFile{
	PackageFile file[MAX_CFILE_NUM];
//	int count[MAX_CFILE_NUM];
	
	PackFile();
	~PackFile();
	
	File* Open( char *fname ); // open file as read-only
	int Close( char *fname ); 
	int Close( int id );
	int OpenCfile( int id, char *filename );
	File* OpenSubfile( int id, char *subname );
	File* OpenNormalFile( char *filename );
	
	void FixFname( char *newfname, char *fname );
};
extern PackFile cfile;

/////////////////////////////////////////////////////////////////////
// ļ

int InitConfig( void );
void ConfigExit( void );
int ConfigSetFile( char *filename );
char* ConfigGetString( char *section, char *name, char *deft );
int ConfigGetInt( char *section, char *name, int deft );
float ConfigGetFloat( char *section, char *name, float deft );
void ConfigSetString( char *section, char *name, char *value );
void ConfigSetInt( char *section, char *name, int value );
void ConfigSetFloat( char *section, char *name, float value );


/////////////////////////////////////////////////////////////////////
//ѹλͼ
class RleBitmap{
public:
	int colorDepth;
	int x, y;		//λý
	int width, height;		//ѹĴС
	DWORD size;			//
	char **line;

	RleBitmap();
	~RleBitmap();

	void ConvertFormat( int format );
};
RleBitmap* CreateRleBitmap( Bitmap* src, int genOl ); // genOlǷ
int SaveRleBitmap( char* filename, RleBitmap* src );
RleBitmap* LoadRleBitmap( char *fname );

void RleBitmapBlit( Bitmap* dest, int x, int y, RleBitmap* src );

void initRleBitmap( void );
void testRleBitmap( void );

/////////////////////////////////////////////////////////////////////
//ѹλͼ
class Animate{
public:
	RleBitmap** pic;
	int totalFrames, currentFrame;
	int x, y;		//
	DWORD size;		//ݳ
	void* data;		//
	int dir;		//ŵķ0:
	int autoReverse;

	Animate();
	~Animate();

	int Draw( Bitmap* dest, int x, int y );
	int DrawCurrentFrame( Bitmap* dest, int x, int y );
	int GetNextFrame( RleBitmap** rbm );
	void Restart( void );
	void SetXY( int x, int y );
};

int SaveAnimate( char* filename );
Animate* LoadAnimate( char* filename );
int MakeAnimateFile( char* filename, RleBitmap** src, int num );

int InitAni( void );
void testAni( void );

#endif		// GRAPHIC_LIB

